﻿using System.Drawing;
using System.Windows.Forms;
using System.Reflection;

namespace Spectral1.SPECTRUM_ANALYSER
{
    public partial class UC_signal_display : UserControl
    {
        #region "=================== DECLARATIONS ================"
        Point[] _waveform_signal_display;
        Pen waveform_pen = new Pen(Color.SpringGreen);
        int centre_y = 200;
        #endregion

        #region "==================== PROPERTIES ========================"

        public Rectangle display_rectangle
        {
            get { return panel1.ClientRectangle; }
        }
        #endregion

        #region "=================== EVENTS ================"
        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            if (_waveform_signal_display == null) return;
            e.Graphics.DrawLines(waveform_pen, _waveform_signal_display);
        }
        #endregion

        #region "=================== METHODS ================"
        public UC_signal_display()
        {
            InitializeComponent();
        }

        public void initialise(Point[] waveform_signal_display)
        {
            _waveform_signal_display = waveform_signal_display;
            centre_y = panel1.ClientRectangle.Height / 2;

            typeof(Panel).InvokeMember("DoubleBuffered", BindingFlags.SetProperty
            | BindingFlags.Instance | BindingFlags.NonPublic, null,
            panel1, new object[] { true });
        }

        #endregion

    }
}
